/*
    Programa de ejemplo
    Copyright (C) 2005 Luis Fernando Llana Diaz

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    A copy of the license can be found at the file "LGPL.txt" and at
    the url http://www.gnu.org/copyleft/lesser.html
*/
package ejemplosRMI.canales;
import java.util.Hashtable;
import java.rmi.RMISecurityManager;
import java.rmi.Naming;
import java.rmi.RemoteException;

/**
 * Prueba.java
 *
 *
 * Created: Wed Apr  2 14:36:37 2003
 *
 * @author <a href="mailto:llana@sip.ucm.es">Luis Fernando Llana Diaz</a>
 * @version $Id: Prueba.java,v 1.4 2005/04/05 21:02:23 luis Exp $
 */

public class Prueba{    
    private static Canal construyeCanal(String nombre, Gestor gestor)
	throws RemoteException, InterruptedException {
	Canal canal=null;
	if (gestor.existeCanal(nombre)) {
	    System.out.println("Canal:"+nombre+":existe:");
	    canal = gestor.canal(nombre);
	    System.out.println("Canal:"+nombre+":recibido:");
	} else {
	    System.out.println("Canal:"+nombre+":NO existe:");
	    canal = new CanalSinc(nombre);
	    gestor.registra(nombre,canal);
	}
	return canal;
    }
    private static void arrancaHebra(String [] descr,Gestor gestor) 
	throws RemoteException, InterruptedException {
	char tipo = descr[0].charAt(0);
	String nombre = descr[1];
	Canal canal = construyeCanal(descr[2],gestor);
	Thread hebra;
	switch (tipo) {
	case 'e':
	    hebra = new Envia(canal,nombre);
	    hebra.start();
	    break;
	case 'r':
	    hebra = new Recibe(canal,nombre);
	    hebra.start();
	    break;
	default:
	    break;
	}
    }
    public static void main(String[] args) throws Exception {
        String url=args[0];
	if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
	}
        System.out.print("Conectando con "+url+"....");
        Gestor gestor = (Gestor)Naming.lookup(url);  
        System.out.println("O.K.");
	int envia=0, recibe=0;
	for (int i = 1;  i < args.length; i++) {
	    System.out.println(args[i]);
	    arrancaHebra(args[i].split(":"),gestor);
	}
    }
} // Prueba
