/*
    Programa de ejemplo
    Copyright (C) 2005 Luis Fernando Llana Diaz

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    A copy of the license can be found at the file "LGPL.txt" and at
    the url http://www.gnu.org/copyleft/lesser.html
*/
package ejemplosRMI.canales;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.rmi.RMISecurityManager;
import java.rmi.Naming;

/**
 * GestorAntares.java
 *
 *
 * Created: Wed Apr  2 12:27:38 2003
 *
 * @author <a href="mailto:llana@sip.ucm.es">Luis Fernando Llana Daz</a>
 * @version $Id: GestorAntares.java,v 1.4 2005/04/05 21:02:13 luis Exp $
 */

public class GestorAntares extends UnicastRemoteObject implements Gestor  {
    private Hashtable tablaCanales;
    public GestorAntares () throws RemoteException {
        tablaCanales = new Hashtable();
    }

    protected static void debug(String mensaje) {
        System.out.print(mensaje);
    }
    protected static void debugln(String mensaje) {
        System.out.println(mensaje);
    }

    public synchronized void registra(String nombre, Canal canal)  throws RemoteException {
        debug("Conectando canal:"+nombre+"...");
	Object c = tablaCanales.get(nombre);
        if (  c != null && ( c instanceof Canal) ) {
            debugln("ya exista\n");
        } else {
            debugln("nuevo");
            tablaCanales.put(nombre,canal);
	    notifyAll();
        }
    }
    public synchronized boolean existeCanal(String nombre)  throws RemoteException {
	Object c = tablaCanales.get(nombre);
	if (c==null) {
	    tablaCanales.put(nombre,new Boolean(false));
	    return false;
	} else {
	    return true;
	}
    }
    public synchronized Canal canal(String nombre)  
	throws RemoteException, InterruptedException {
	Object c=tablaCanales.get(nombre);
	while (c==null || !(c instanceof Canal)) {
	    wait();
	    c=tablaCanales.get(nombre);
	}
	return (Canal)c;
    }
    public static void main (String[] args) {
         if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
         }
	 String nombre = args[0];
        try {
            GestorAntares gestor = new GestorAntares();
            Naming.rebind(nombre,gestor);
            debugln("Gestor funcionando");
        } catch (Exception e) {
            System.err.println("Excepcin en GestorAntares: " + e.getMessage());
            e.printStackTrace();
        }
            
    } // end of main ()
    
}// GestorAntares
