/*
    Programa de ejemplo
    Copyright (C) 2005 Luis Fernando Llana Diaz

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    A copy of the license can be found at the file "LGPL.txt" and at
    the url http://www.gnu.org/copyleft/lesser.html
*/
package ejemplosRMI.canales;

import java.util.Random;
import java.rmi.RemoteException;

/**
 * Envia.java
 *
 *
 * Created: Wed Apr  2 13:59:42 2003
 *
 * @author <a href="mailto:llana@sip.ucm.es">Luis Fernando Llana Daz</a>
 * @version $Id: Envia.java,v 1.3 2005/02/13 22:18:15 luis Exp $
 */

public class Envia extends Thread {
    private Random r;
    private Canal canal;
    private String nombre;
    public Envia (Canal c, String np) {
	canal = c;
        nombre = np;
	r = new Random();
        try {sleep(173);} catch ( InterruptedException e ) {}
    }
    public void run() {
        while ( true ) {
             try {
                int espera = r.nextInt(100);
                sleep(espera);
                System.out.println("Proceso:"+nombre+": enva "+espera+" al canal:"+canal.nombre()+":");
		Integer n = new Integer(espera);
                canal.envia(n);
                System.out.println("Proceso:"+nombre+": enviado:"+n);
            } catch ( InterruptedException e ) {
                throw new RuntimeException(e);
            } catch ( RemoteException e ) {
                throw new RuntimeException(e);
            }
        }
    }
}// Envia
