/*
    Programa de ejemplo
    Copyright (C) 2005 Luis Fernando Llana Diaz

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    A copy of the license can be found at the file "LGPL.txt" and at
    the url http://www.gnu.org/copyleft/lesser.html
*/
package ejemplosRMI.canales;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class CanalSinc  extends UnicastRemoteObject implements Canal{
    private String nombre;
    private Object mensaje;
    private boolean lleno;
    private boolean leido;
    public CanalSinc (String n) throws RemoteException{
        nombre = n;
        mensaje = null;
        lleno = false;
        leido = true;
    }
    public synchronized void envia(Object param1) throws RemoteException {
        try {
            while ( lleno  ) {
                wait();
            }
            lleno = true;
            leido = false;
            mensaje = param1;
            notifyAll();
            while ( !leido ) {
                wait();
            }
        } catch ( InterruptedException e ) {
            throw new RuntimeException(e);
        }
        
    }

    public synchronized Object recibe()  throws RemoteException {
        try {
            while ( !lleno ) {
                wait();
            }
            lleno = false;
            leido = true;
            notifyAll();
        } catch ( InterruptedException e ) {
            throw new RuntimeException(e);
        }
        return mensaje;           
    }
    public String nombre() throws RemoteException {
	return nombre;
    }
    public String toString(){
        String msg="("+nombre+":";
        msg += lleno? mensaje.toString() : "null";
        msg += ")";
        return msg;
    }
}// CanalAntares
