package servidorCanales;
import java.rmi.*;
import java.rmi.server.*;
import java.util.*;
import java.io.*;
import pruebaCanales.*;
/**
 * GestorAntares.java
 *
 *
 * Created: Wed Apr  2 12:27:38 2003
 *
 * @author <a href="mailto:llana@sip.ucm.es">Luis Fernando Llana Daz</a>
 * @version
 */

public class GestorAntares extends UnicastRemoteObject implements Gestor  {
    private Hashtable tablaCanales;
    public GestorAntares () throws RemoteException{
        tablaCanales = new Hashtable();
    }
    // implementation of servidorCanales.Gestor interface

    /**
     *
     * @return <description>
     */
    protected static void debug(String mensaje) {
        System.out.print(mensaje);
    }
    protected static void debugln(String mensaje) {
        System.out.println(mensaje);
    }
    public void envia(String nombreCanal, Object mensaje) throws RemoteException
    {
        Canal canal = (Canal)tablaCanales.get(nombreCanal);
        canal.envia(mensaje);
    }
    public Object recibe(String nombreCanal) throws RemoteException 
    {
        Canal canal = (Canal)tablaCanales.get(nombreCanal);
        return canal.recibe();
    }

    public synchronized void conecta(String nombre)  throws RemoteException
    {
        debug("Conectando canal:"+nombre+"...");
        Canal canal = (Canal)tablaCanales.get(nombre);
        if ( canal != null ) {
            debugln("ya exista\n");
        } else {
            debugln("nuevo");
            canal = new Canal(nombre);
            tablaCanales.put(nombre,canal);
        }
    }
    public static void main (String[] args) {
         if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
         }
        String nombre = "rmi://antares.sip.ucm.es/GestorCanales";
        try {
            GestorAntares gestor = new GestorAntares();
            Naming.rebind(nombre,gestor);
            debugln("Gestor funcionando");
        } catch (Exception e) {
            System.err.println("Excepcin en GestorAntares: " + e.getMessage());
            e.printStackTrace();
        }
            
    } // end of main ()
    
}// GestorAntares
