all: pdf.pdf
2pdf: $(nombre).2.pdf
.SUFFIXES: .eps .eps.gz .fig .gif .txt .java .eps .tex .ps .dvi\
					 -8.eps -8.eps.gz \
					 -9.eps -9.eps.gz \
					 -10.eps -10.eps.gz \
					 -11.eps -11.eps.gz \
					 -12.eps -12.eps.gz \
					 -1.eps -1.eps.gz \
					 -2.eps -2.eps.gz \
					 -3.eps -3.eps.gz \
					 -4.eps -4.eps.gz \
					 -5.eps -5.eps.gz \
					 -6.eps -6.eps.gz \
					 -7.eps -7.eps.gz
.eps.eps.gz:
				comprimeEPS $<
.fig.eps:
				fichero=$<; \
				fig2dev -Leps $$fichero > $${fichero%.fig}.eps
%.png: %.fig
	fig2dev -Lpng $< > $@
.fig.pdf:
%.pdf: %.fig
	fig2dev -Lpdf $< > $@
%.png: %.fig
	fig2dev -Lpdf $< > $@
.gif.eps:
				fichero=$<; \
				convert $$fichero  $${fichero%.gif}.eps
				fichero=$<; \
				convert $$fichero  $${fichero%.jpeg}.eps
%.eps: %.png
	fichero=$<; convert $$fichero  $${fichero%.png}.eps

%.eps: %.jpeg
	fichero=$<; convert $$fichero  $${fichero%.jpeg}.eps
%.eps: %.svg
	fichero=$<; convert $$fichero  $${fichero%.svg}.eps
%.png: %.svg
	convert $< $@
.java.eps:
				fichero=$<; \
				a2ps -r --columns=1 --line-numbers=5 --chars-per-line=85 $$fichero \
				-o $${fichero%.java}.eps
.txt.eps:
				fichero=$<; \
				a2ps -r --columns=1 --line-numbers=5 --chars-per-line=85 $$fichero \
				-o $${fichero%.txt}.eps
.eps-1.eps:
				fichero=$<; \
				psselect -p1 $$fichero > $${fichero%.eps}-1.eps
.eps-2.eps:
				fichero=$<; \
				psselect -p2 $$fichero > $${fichero%.eps}-2.eps
.eps-3.eps:
				fichero=$<; \
				psselect -p3 $$fichero > $${fichero%.eps}-3.eps
.eps-4.eps:
				fichero=$<; \
				psselect -p4 $$fichero > $${fichero%.eps}-4.eps
.eps-5.eps:
				fichero=$<; \
				psselect -p5 $$fichero > $${fichero%.eps}-5.eps
.eps-6.eps:
				fichero=$<; \
				psselect -p6 $$fichero > $${fichero%.eps}-6.eps
.eps-7.eps:
				fichero=$<; \
				psselect -p7 $$fichero > $${fichero%.eps}-7.eps
.eps-8.eps:
				fichero=$<; \
				psselect -p8 $$fichero > $${fichero%.eps}-8.eps
.eps-9.eps:
				fichero=$<; \
				psselect -p9 $$fichero > $${fichero%.eps}-9.eps
.eps-10.eps:
				fichero=$<; \
				psselect -p10 $$fichero > $${fichero%.eps}-10.eps
.eps-11.eps:
				fichero=$<; \
				psselect -p11 $$fichero > $${fichero%.eps}-11.eps
.tex.dvi:
				fichero=$<; \
				latex $${fichero%.tex}
%.txt: %.dvi  $(inputLaTeX)
	fichero=$<; \
	dvi2tty -o $${fichero%.dvi}.txt $$fichero

# preambulo.tex:
# 	rm -fv $(transpa).fmt
# 	ln -sf preambuloPS.tex preambulo.tex


# $(transpa).fmt: preambulo.tex macros.tex
# 				mylatex $(transpa).tex

$(nombre).pdf: pdf.pdf
	mv pdf.pdf $(nombre).pdf
$(nombre).2.pdf: pdf.2.pdf
	mv pdf.2.pdf $(nombre).2.pdf

pdf.fmt: pdf.tex macros.tex
	etex --ini \&pdflatex mylatex.ltx $<
	mv mylatex.fmt $@
pdf.pdf: pdf.fmt transparencias.tex $(ficherosNecesarios)
	etex \&pdf pdf.tex
pdf.2.pdf: pdf.2.tex macros.tex transparencias.tex $(ficherosNecesarios)
	pdflatex pdf.2.tex

install: $(nombre).pdf $(nombre).2.pdf
	cp $(nombre).pdf $(destino)/$(nombre).pdf
	cp $(nombre).2.pdf $(destino)/$(nombre).2.pdf
	cp $(nombre).2.pdf ..
	make limpia
	cd ..; tar czvf  $(destino)/$(nombre).tgz $(nombre)

_limpia:
				for ext in png gif fig jpeg svg; do \
					for a in *.$$ext; do \
						rm -fv $${a%.$$ext}.eps; \
						rm -fv $${a%.$$ext}.eps.bb; \
						rm -fv $${a%.$$ext}.eps.gz; \
					done; \
				done
				for a in pdf pdf.2; do \
				  rm -fv $$a.ps ; \
				  rm -fv $$a.4.ps; \
				  rm -fv $$a.4.ps.gz; \
				  rm -fv $$a.pdf-ps; \
				  rm -fv $$a.pdf; \
				  rm -fv $$a.out; \
				  rm -fv $$a.aux; \
				  rm -fv $$a.log; \
				  rm -fv $$a.dvi; \
				  rm -fv $$a.fmt; \
				  rm -fv $$a.nav; \
				  rm -fv $$a.snm; \
				  rm -fv $$a.toc; \
				  rm -fv $$a.txt; \
				  rm -fv $$a.vrb; \
				done
				rm -fv *~
				rm -fv *~ body.tmp  head.tmp
				rm -frv auto


