transpa = transparencias
all: $(transpa).pdf
4ps: $(transpa).4.ps
.SUFFIXES: .eps .eps.gz .fig .gif .txt .java .eps .tex .ps .dvi\
					 -8.eps -8.eps.gz \
					 -9.eps -9.eps.gz \
					 -10.eps -10.eps.gz \
					 -11.eps -11.eps.gz \
					 -12.eps -12.eps.gz \
					 -1.eps -1.eps.gz \
					 -2.eps -2.eps.gz \
					 -3.eps -3.eps.gz \
					 -4.eps -4.eps.gz \
					 -5.eps -5.eps.gz \
					 -6.eps -6.eps.gz \
					 -7.eps -7.eps.gz
.eps.eps.gz:
				comprimeEPS $<
.fig.eps:
				fichero=$<; \
				fig2dev -Leps $$fichero > $${fichero%.fig}.eps
.gif.eps:
				fichero=$<; \
				convert $$fichero  $${fichero%.gif}.eps
				fichero=$<; \
				convert $$fichero  $${fichero%.jpeg}.eps
%.eps: %.png
	fichero=$<; convert $$fichero  $${fichero%.png}.eps

%.eps: %.jpeg
	fichero=$<; convert $$fichero  $${fichero%.jpeg}.eps
%.eps: %.svg
	fichero=$<; convert $$fichero  $${fichero%.svg}.eps
.java.eps:
				fichero=$<; \
				a2ps -r --columns=1 --line-numbers=5 --chars-per-line=85 $$fichero \
				-o $${fichero%.java}.eps
.txt.eps:
				fichero=$<; \
				a2ps -r --columns=1 --line-numbers=5 --chars-per-line=85 $$fichero \
				-o $${fichero%.txt}.eps
.eps-1.eps:
				fichero=$<; \
				psselect -p1 $$fichero > $${fichero%.eps}-1.eps
.eps-2.eps:
				fichero=$<; \
				psselect -p2 $$fichero > $${fichero%.eps}-2.eps
.eps-3.eps:
				fichero=$<; \
				psselect -p3 $$fichero > $${fichero%.eps}-3.eps
.eps-4.eps:
				fichero=$<; \
				psselect -p4 $$fichero > $${fichero%.eps}-4.eps
.eps-5.eps:
				fichero=$<; \
				psselect -p5 $$fichero > $${fichero%.eps}-5.eps
.eps-6.eps:
				fichero=$<; \
				psselect -p6 $$fichero > $${fichero%.eps}-6.eps
.eps-7.eps:
				fichero=$<; \
				psselect -p7 $$fichero > $${fichero%.eps}-7.eps
.eps-8.eps:
				fichero=$<; \
				psselect -p8 $$fichero > $${fichero%.eps}-8.eps
.eps-9.eps:
				fichero=$<; \
				psselect -p9 $$fichero > $${fichero%.eps}-9.eps
.eps-10.eps:
				fichero=$<; \
				psselect -p10 $$fichero > $${fichero%.eps}-10.eps
.eps-11.eps:
				fichero=$<; \
				psselect -p11 $$fichero > $${fichero%.eps}-11.eps
.tex.dvi:
				fichero=$<; \
				latex $${fichero%.tex}
%.txt: %.dvi  $(inputLaTeX)
	fichero=$<; \
	dvi2tty -o $${fichero%.dvi}.txt $$fichero

preambuloPDF:
	ln -sf preambuloPDF.tex preambulo.tex	
preambuloPS:
	ln -sf preambuloPS.tex preambulo.tex	
# preambulo.tex:
# 	rm -fv $(transpa).fmt
# 	ln -sf preambuloPS.tex preambulo.tex


# $(transpa).fmt: preambulo.tex macros.tex
# 				mylatex $(transpa).tex

$(transpa).dvi: $(transpa).tex macros.tex preambulo.tex $(ficherosNecesarios)
$(transpa).ps: preambuloPS $(transpa).dvi
	dvips -Ppdf -t a4 $(transpa)
#$(transpa).4.ps: preambuloPS.tex $(transpa).ps
#	psnup -4 -W128mm -H96mm -pa4 -b 1cm $(transpa).ps $@
$(transpa).4.ps: preambuloPS $(ficherosNecesarios)
	rm -fv $(transpa).dvi
	latex $(transpa)
	dvips -o $(transpa).4.ps $(transpa) 
$(transpa).4.ps.gz: $(transpa).4.ps
	gzip $(transpa).4.ps
$(transpa).pdf: preambuloPDF.tex $(transpa).pdf-ps
$(transpa).pdf-ps: preambuloPDF $(transpa).dvi $(inputLaTeX)
	dvips -Ppdf -o$@ $(transpa)

%.pdf: %.pdf-ps $(inputLaTeX) preambuloPDF
	fichero=$<; \
	ps2pdf $$fichero $${fichero%.pdf-ps}.pdf

install: $(transpa).pdf $(transpa).4.ps.gz
	cp $(transpa).pdf $(destino)/$(nombre).pdf
	cp $(transpa).4.ps.gz $(destino)/$(nombre).4.ps.gz
	make limpia
	cd ..; tar czvf  $(destino)/$(nombre).tgz $(nombre)
ver:$(transpa).ps
				gv $(transpa).ps &
limpia:
				for ext in png gif fig jpeg svg; do \
					for a in *.$$ext; do \
						rm -fv $${a%.$$ext}.eps; \
						rm -fv $${a%.$$ext}.eps.bb; \
						rm -fv $${a%.$$ext}.eps.gz; \
					done; \
				done
				rm -fv $(transpa).ps
				rm -fv $(transpa).4.ps
				rm -fv $(transpa).4.ps.gz
				rm -fv $(transpa).pdf-ps
				rm -fv $(transpa).pdf
				rm -fv $(transpa).out
				rm -fv $(transpa).aux
				rm -fv $(transpa).log
				rm -fv $(transpa).dvi
				rm -fv $(transpa).fmt
				rm -fv $(transpa).nav
				rm -fv $(transpa).snm
				rm -fv $(transpa).toc
				rm -fv $(transpa).txt
				rm -fv $(transpa).vrb
				rm -fv *~
				rm -fv *~ body.tmp  head.tmp
				rm -frv auto


