import javax.servlet.http.HttpServlet;
import javax.servlet.ServletException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.RequestDispatcher;

/*
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 */
/**
 * Describe class Sesion here.
 *
 *
 * Created: Mon Apr 18 10:32:06 2005
 *
 * @author <a href="mailto:luis@antares.sip.ucm.es">Luis Fernando Llana Díaz</a>
 * @version $Id: Sesion.java,v 1.4 2007-05-09 22:30:20 luis Exp $
 */
public class Sesion extends HttpServlet {
    public final static String strNombre="nombre";
    public final static String strNumAccesos="numAccesos";
    private final static String strBorraSesion="borraSesion";
    private ServletConfig config;
    /**
     * Describe <code>init</code> method here.
     *
     * @param servletConfig a <code>ServletConfig</code> value
     * @exception ServletException if an error occurs
     */
    public final void init(final ServletConfig c) throws ServletException {
	config=c;
    }

    /**
     * Describe <code>doGet</code> method here.
     *
     * @param httpServletRequest a <code>HttpServletRequest</code> value
     * @param httpServletResponse a <code>HttpServletResponse</code> value
     * @exception ServletException if an error occurs
     * @exception IOException if an error occurs
     */
    public final void doGet(final HttpServletRequest request, 
			    final HttpServletResponse response) 
	throws ServletException, IOException {
	HttpSession sesion = request.getSession();
	//El nombre en esta sesión nunca es vacío
	String nombre =(String)sesion.getAttribute(strNombre);
	Integer numAccesos = (Integer)sesion.getAttribute(strNumAccesos);
	if (numAccesos==null) {
	    numAccesos = new Integer(0);
	}
	sesion.setAttribute(strNumAccesos, new Integer(numAccesos.intValue()+1));
	String borroSesion = request.getParameter(strBorraSesion);
	StringBuffer contenido = new StringBuffer();
	contenido.append(saludo(nombre,numAccesos));
	if (borroSesion!=null) {
	    contenido.append(sesionBorrada(response));
	    sesion.removeAttribute(strNumAccesos);
	    sesion.removeAttribute(strNombre);
	} else {
	    contenido.append(formularioContinua(response));
	}
	ServletOutputStream out = response.getOutputStream();
	response.setContentType("text/html");
	RequestDispatcher rd = request.getRequestDispatcher(Fecha.strServlet);
	request.setAttribute(Fecha.strID, "fecha");
	rd.include(request, response);
	out.println(contenido.toString());	
    }
    private StringBuffer saludo(String nombre, Integer numAccesos) {
	StringBuffer sb = new StringBuffer();
	sb.append("<p>Hola "+nombre+"</p>\n");
	sb.append("<p>En esta sesión has accedido "+(numAccesos.intValue()+1)+" veces</p>\n");
	return sb;
    }
    private StringBuffer sesionBorrada(HttpServletResponse response) {
	StringBuffer sb = new StringBuffer();
	sb.append("<p>La sesión acaba de ser borrada</p>\n");
	sb.append("<p><a href=\""+response.encodeURL(config.getServletName())+"\">Conectar otra vez</a></p>");
	return sb;
    }
    private StringBuffer formularioContinua(HttpServletResponse response) {
	StringBuffer sb = new StringBuffer();
	sb.append("<form type=\"get\" action=\"");
	sb.append(response.encodeURL(config.getServletName()));
	sb.append("\">\n");
	sb.append("  <p><button name=\"continuar\" type=\"submit\">Continuar</button></p>\n");
	sb.append("  <p><button name=\"");
	sb.append(strBorraSesion);
	sb.append("\" type=\"submit\">Borrar sesión</button></p>\n");
	sb.append("</form>\n");
	return sb;	
    }
}
