import javax.servlet.Filter;
import javax.servlet.ServletException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletResponse;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.FilterConfig;
import javax.servlet.ServletOutputStream;

/*
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 */
/**
 * Describe class Login here.
 *
 *
 * Created: Mon Apr 18 11:48:51 2005
 *
 * @author <a href="mailto:luis@antares.sip.ucm.es">Luis Fernando Llana Díaz</a>
 * @version $Id: Login.java,v 1.6 2007-05-10 20:08:03 luis Exp $
 */
public class Login implements Filter {
    private static final String strServlet="servlet";
    private static final String strNombre="nombre";
    private FilterConfig config;
    public void init(FilterConfig filterConfig) throws ServletException {
        config = filterConfig;
    }
    public void destroy() { }
    /**
     * Describe <code>doFilter</code> method here.
     *
     * @param servletRequest a <code>ServletRequest</code> value
     * @param servletResponse a <code>ServletResponse</code> value
     * @param filterChain a <code>FilterChain</code> value
     * @exception IOException if an error occurs
     * @exception ServletException if an error occurs
     */
    public final void doFilter(final ServletRequest request, 
			       final ServletResponse response, 
			       final FilterChain filterChain) 
	throws IOException, ServletException {
	HttpSession sesion = ((HttpServletRequest)request).getSession();
	String nombre=(String)sesion.getAttribute(Sesion.strNombre);
	if (nombre==null) {
	    nombre = request.getParameter(strNombre);
	    if (nombre==null) {
		pideNombre((HttpServletRequest)request,(HttpServletResponse)response);
	    } else {
		sesion.setAttribute(Sesion.strNombre,nombre);
		filterChain.doFilter(request, response);
	    }
	} else {
	    filterChain.doFilter(request, response);
	}
    }
    private void pideNombre(final HttpServletRequest request, 
			    final HttpServletResponse response) 
	throws IOException, ServletException {
	ServletOutputStream out = response.getOutputStream();
	String uri = request.getRequestURI();
	response.setContentType("text/html");
	out.println("<form type=\"get\" action=\""+response.encodeURL(uri)+"\">\n");
	out.println(" <p>\n");
	out.println("   <label for=\""+strNombre+"\">Nombre:</label>");
	out.println("   <input id=\""+strNombre+"\"name=\""+strNombre+"\">\n");
	out.println("   <button type=\"submit\">Login</button>\n");
	out.println(" </p>\n");
	out.println("</form>");
    }
}
