import javax.servlet.http.HttpServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.FileWriter;

/*
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 */
/**
 * Describe class Contador here.
 *
 *
 * Created: Sun Apr 17 17:30:53 2005
 *
 * @author <a href="mailto:luis@guerrano">Luis Fernando Llana Díaz</a>
 * @version $Id: Contador.java,v 1.4 2007-05-09 22:30:20 luis Exp $
 */
public class Contador extends HttpServlet {
    
    private int contador;
    private ServletConfig config;
    private final static String strFichero="fichero";
    /**
     * Describe <code>init</code> method here.
     *
     * @param servletConfig a <code>ServletConfig</code> value
     * @exception ServletException if an error occurs
     */
    public final void init(final ServletConfig c) 
	throws ServletException {
	config = c;
	ServletContext ctx = config.getServletContext();
	String fichero = config.getInitParameter(strFichero);
	try {
	    BufferedReader f
		= new BufferedReader(
		    new FileReader(ctx.getRealPath(fichero)));
	    contador = Integer.parseInt(f.readLine());
	    f.close();

	} catch (FileNotFoundException e) {
	    contador = 0;
	} catch (IOException e) {
	    contador = 0;
	}
    }

    /**
     * Describe <code>destroy</code> method here.
     *
     */
    public final void destroy() {
	ServletContext ctx = config.getServletContext();
	String fichero = config.getInitParameter(strFichero);
	try {
	    FileWriter f = new FileWriter(ctx.getRealPath(fichero));
	    f.write(contador+"\n");
	    f.close();
	} catch (IOException e) {
	    throw new RuntimeException(e.getLocalizedMessage());
	}

    }

    private synchronized int incrementa() {
	contador++;
	return contador;
    }

    /**
     * Describe <code>doGet</code> method here.
     *
     * @param httpServletRequest a <code>HttpServletRequest</code> value
     * @param httpServletResponse a <code>HttpServletResponse</code> value
     * @exception ServletException if an error occurs
     * @exception IOException if an error occurs
     */
    public final void doGet(final HttpServletRequest request, 
			    final HttpServletResponse response) 
	throws ServletException, IOException {
	int n=incrementa();
	ServletOutputStream out = response.getOutputStream();
	String nombre = request.getParameter("nombre");
	response.setContentType("text/html");
	out.println(" <p>Número de accesos:"+n+"</p>");
    }
}
