package soporte.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import soporte.html.Tags;
import soporte.IncluyeFichero;

/**
 * Describe class MierdaExplorer here.
 *
 *
 * Created: Wed Dec 22 23:58:15 2004
 *
 * @author <a href="mailto:luis@principal.interna">Luis Fernando Llana Díaz</a>
 * @version $Id: MierdaExplorer.java,v 1.1 2007-05-10 20:41:41 luis Exp $
 */
public class MierdaExplorer implements Filter {
    private FilterConfig config;
    public void init(FilterConfig filterConfig) throws ServletException {
        config = filterConfig;
    }

    public void destroy() {
        config=null;
    }

    private static String javaScript="javaScript/mierdaExplorer.js";
    
    private static boolean esIE(HttpServletRequest req) {
	String userAgent = req.getHeader("user-agent");
	return userAgent.toLowerCase().indexOf("msie")>0;
    }
     /**
     * Describe <code>doFilter</code> method here.
     *
     * @param servletRequest a <code>ServletRequest</code> value
     * @param servletResponse a <code>ServletResponse</code> value
     * @param filterChain a <code>FilterChain</code> value
     * @exception IOException if an error occurs
     * @exception ServletException if an error occurs
     */
    public final void doFilter(final ServletRequest _request,
			       final ServletResponse response,
			       final FilterChain filterChain)
	throws IOException, ServletException {
	HttpServletRequest request = (HttpServletRequest)_request;
	HttpServletResponse responseString
	    = new ResponseString((HttpServletResponse)response);
	ServletOutputStream out = responseString.getOutputStream();
	Enumeration nombres = request.getHeaderNames();
	if (esIE(request)) {
	    ServletContext ctx = config.getServletContext();
	    out.println(Tags.script("",IncluyeFichero.incluye(ctx.getRealPath(javaScript))));
 	    out.println(Tags.p("","Mierda de explorer"));
	} else {
 	    out.println(Tags.p("","Menos mal que es un navegador decente"));
	}
	filterChain.doFilter(request,responseString);
	out = response.getOutputStream();
	String res = responseString.toString();
	if (esIE(request)) {
	    res = reemplazaBoton(res);
	}
	out.println(res);
	if (esIE(request)) {
	    out.println(Tags.p(Tags.clase("disclaimer"),"This pages require an HTML 4.01 compliant navigator. Unfortunately Internet Explorer is not, thus we do not guarantee their correct behavior in that browser"));
	}
	
    }

    public static String reemplazaBoton(String codigo) {
	Pattern p = Pattern.compile("<button *name=\"([^\"]*)\" *"+
				    "type=\"([^\"]*)\" *"+
				    "value=\"([^\"]*)\" *"+
				    "([^<>]*)>([^<>]*)</button>");
	String res = codigo;
	Matcher m = p.matcher(res);
	while (m.find()) {
	    String tipo=m.group(2);
	    String nombre=m.group(1);
	    String valor=m.group(3);
	    String attrExtra=m.group(4);
	    String texto=m.group(5);
// 	    for (int i = 0; i <= m.groupCount() ; i++) {
// 		System.out.println(i+":"+m.group(i));
// 	    }
// 	    System.out.println("-----");
	    String nuevo =
		Tags.input("",nombre,Tags.type(tipo)+
			   Tags.value(texto)+
			   Tags.attribute("onclick","cambiaValor(this,'"+valor+"')")+
			   attrExtra);
	    res = m.replaceFirst(nuevo);
	    m = p.matcher(res);
	}
	return res;
    }
    public static final void main(final String[] args) {
	String boton="<button  name=\"inputFoco\"  type=\"submit\"  value=\"seleccionFecha_tipoSeleccion_todasFechas\"  class=\"actualizaDatos\"  title=\"actualiza datos\"  id=\"seleccionFecha_tipoSeleccion_todasFechas_submit\" >R</button>:111 1 11  1  1 1 1  1 1 1  1:<button  name=\"inputFoco\"  type=\"submit\"  value=\"seleccionObra_antiguedad\"  class=\"actualizaDatos\"  title=\"actualiza datos\"  id=\"seleccionObra_antiguedad_submit\" >R</button>:222 22 22";
	String s = reemplazaBoton(boton);
	System.out.println(s);
    }
    
}
