/*
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 */
 
package soporte.html;

import java.util.*;



/**
 * SelectOptions.java
 * This class is to be used as to represent an option tag inside an select tag.
 * 
 *
 * Created: Sun Feb  8 22:32:51 2004
 *
 * @author <a href="mailto:luis@valla.org">Luis Fernando Llana Díaz</a>
 * @version $Id: SelectOption.java,v 1.1 2007-05-09 22:30:20 luis Exp $
 */
public class SelectOption {
    private String text;
    private String value;
    private String attrs;

    /**
     * Creates a new <code>SelectOptions</code> instance.
     *
     * @param text a <code>String</code> value with the option text.
     * @param value a <code>String</code> value with the option value.
     */
    public SelectOption(String text, String value) {
	this(text,value,"");
    }
    
    
    /**
     * Creates a new <code>SelectOptions</code> instance.
     *
     * @param _text a <code>String</code> value  option text.
     * @param _value a <code>String</code> value option value.
     * @param _attrs a <code>String</code> value with the option attibutes
     */
    public SelectOption(String _text, String _value, String _attrs) {
	text = _text;
	value = _value;
	attrs = _attrs;
    } // OpcionesSelect constructor
    
    
    /**
     * Get the Text value.
     * @return the Text value.
     */
    public String getText() {
	return text;
    }

    /**
     * Set the Text value.
     * @param newText The new Text value.
     */
    public void setText(String newText) {
	this.text = newText;
    }
    /**
     * Get the Value value.
     * @return the Value value.
     */
    public String getValue() {
	return value;
    }
    /**
     * Get the <code>Attrs</code> value.
     *
     * @return a <code>String</code> value
     */
    public final String getAttrs() {
	return attrs;
    }

    /**
     * Set the Value value.
     * @param newValue The new Value value.
     */
    public void setValue(String newValue) {
	this.value = newValue;
    }
    
    /**
     * The <code>lookupText</code> method look up into a list of options the given value and return
     * its associate text.
     *
     * @param list an <code>AbstractSequentialList</code> value containing a list of options.
     * @param opcion a <code>String</code>  with the value to look up.
     * @return a <code>String</code> with the text associated to the value.
     */
    public static String lookupText
	(AbstractSequentialList list, String value) {
	for (Iterator  itr = list.iterator(); itr.hasNext();) {
	    SelectOption op = (SelectOption)itr.next();
	    if ( value.equals(op.getValue()) ) {
		return op.getText();
	    }
	}
	return "no-text:"+value+":";
    }
} // OpcionesSelect
