import java.util.Random;


/**
 * FilosofosFacil.java
 *
 *
 * Created: Tue Apr 20 20:33:06 2004
 *
 * @author <a href="mailto:luis@hotmail.com"></a>
 * @version 1.0
 */
public class Mesa {
    private int numFilosofos;
    protected boolean [] comiendo;
    private static Mesa mesa=null;
    
    
    private Mesa(int n) {
	numFilosofos = n;;
	comiendo = new boolean[numFilosofos];
	for (int i = 0; i < numFilosofos; i++) {
	    comiendo[i] = false;
	}
    }
    public static Mesa getMesa(int n) {
	if (mesa==null) {
	    mesa=new Mesa(n);
	} else {
	    if (mesa.numFilosofos!=n) {
		throw new RuntimeException("Monitor de filósofos ya construido con "+mesa.numFilosofos+" filósofos. No puedo darte uno de "+n);
	    }
	}
	return mesa;
    }
    
    public int sig(int i) {
	return (i+1) % numFilosofos;
    }
    public int ant(int i) {
	return  ( i-1+numFilosofos ) % numFilosofos;
    }
    
    public String toString(){
	StringBuffer res=new StringBuffer();
	for (int  i = 0; i < numFilosofos; i++) {
	    if (res.length()==0) {
		res.append('(');
	    } else {
		res.append(',');
	    }
	    res.append(comiendo[i]);
	}
	res.append(')');
	return res.toString();
    }
    public synchronized void permisoComer(int i) throws InterruptedException{
	while (comiendo[ant(i)] || comiendo[sig(i)]) { 
	    wait();
	}
	comiendo[i]=true;
    }
    public synchronized void cedePermiso(int i) {
	comiendo[i]=false;
	notifyAll();
    }
} 
