import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import soporte.html.Tags;

/*
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 */
/**
 * Describe class Login here.
 *
 *
 * Created: Mon Apr 18 11:48:51 2005
 *
 * @author <a href="mailto:luis@antares.sip.ucm.es">Luis Fernando Llana Díaz</a>
 * @version $Id: Login.java,v 1.1 2007-05-09 22:30:20 luis Exp $
 */
public class Login implements Filter {
    private FilterConfig config;
    public void init(FilterConfig filterConfig) throws ServletException {
        config = filterConfig;
    }
    public void destroy() { }
    /**
     * Describe <code>doFilter</code> method here.
     *
     * @param servletRequest a <code>ServletRequest</code> value
     * @param servletResponse a <code>ServletResponse</code> value
     * @param filterChain a <code>FilterChain</code> value
     * @exception IOException if an error occurs
     * @exception ServletException if an error occurs
     */
    public final void doFilter(final ServletRequest request, 
			       final ServletResponse response, 
			       final FilterChain filterChain) 
	throws IOException, ServletException {
	HttpSession sesion = ((HttpServletRequest)request).getSession();
	Integer filosofoID=(Integer)sesion.getAttribute(Filosofo.strFilosofoID);
	if (filosofoID==null) {
	    String ID_str = request.getParameter(Filosofo.strFilosofoID);
	    if (ID_str==null) {
		pideNombre((HttpServletRequest)request,(HttpServletResponse)response);
	    } else {
		try {
		    Integer ID=new Integer(ID_str);
		    sesion.setAttribute(Filosofo.strFilosofoID,ID);
		    filterChain.doFilter(request, response);
		} catch (NumberFormatException e) {
		    pideNombre((HttpServletRequest)request,(HttpServletResponse)response);		    
		}
	    }
	} else {
	    filterChain.doFilter(request, response);
	}
    }
    private void pideNombre(final HttpServletRequest request, 
			    final HttpServletResponse response) 
	throws IOException, ServletException {
	ServletOutputStream out = response.getOutputStream();
	String URI = ((HttpServletRequest)request).getRequestURI();
	response.setContentType("text/html");
	out.println(Tags.form(response.encodeURL(URI),"get","",
			      Tags.p("",
				     Tags.label(Filosofo.strFilosofoID,"","Nombre:")+
				     Tags.input(Filosofo.strFilosofoID,Filosofo.strFilosofoID,"")+
				     Tags.button("enviar",Tags.strSubmit,"enviar","","Enviar"))));
    }
}
