import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import soporte.html.Tags;

/*
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 */
/**
 * Describe class Filosofo here.
 *
 *
 * Created: Wed May  9 23:22:48 2007
 *
 * @author <a href="mailto:patata@patata.com">Patata</a>
 * @version $Id: Filosofo.java,v 1.3 2007-05-10 12:56:17 luis Exp $
 */
public class Filosofo extends HttpServlet {
    public static final String strFilosofoID="filosofoID";
    private static final int NUM_FILOSOFOS=5;
    private static final String strFilosofo="filosofo";
    private static final String strAccion="accion";
    private static final String strComer="comer";
    private static final String strPensar="pensar";
    public static final String strMesa="mesa";
    private Mesa mesa;

    /**
     * Describe <code>init</code> method here.
     *
     * @exception ServletException if an error occurs
     */
    public final void init(ServletConfig config) throws ServletException {
	ServletContext ctx = config.getServletContext();
	Mesa ctxMesa = (Mesa) ctx.getAttribute(strMesa);
	if (ctxMesa!=null ) {
	    mesa = ctxMesa;
	} else {
	    mesa = Mesa.getMesa(NUM_FILOSOFOS);
	    ctx.setAttribute(strMesa,mesa);
	}
    }

    /**
     * Describe <code>doGet</code> method here.
     *
     * @param httpServletRequest a <code>HttpServletRequest</code> value
     * @param httpServletResponse a <code>HttpServletResponse</code> value
     * @exception ServletException if an error occurs
     * @exception IOException if an error occurs
     */
    public final void doGet(final HttpServletRequest request, final HttpServletResponse response)
	throws ServletException, IOException {
	response.setContentType("text/html");
	HttpSession sesion = request.getSession();
	String accion = request.getParameter(strAccion);
	if ( accion==null || accion.equals(strPensar) ) {
	    pensar(request,response);
	} else {
	    comer(request,response);
	}
    }

    public final void pensar(final HttpServletRequest request, final HttpServletResponse response)
	throws ServletException, IOException {
	ServletOutputStream out = response.getOutputStream();
	String accion = request.getParameter(strAccion);
	HttpSession sesion = request.getSession();
 	Integer ID = (Integer)sesion.getAttribute(strFilosofoID);
	if (accion!=null) {
	    mesa.cedePermiso(ID.intValue());
	}
	out.println(Tags.p("","Filósofo "+ID+" pensando, cuando quiera comer pulsar el botón"));
	out.println(Tags.p("","Estado del monitor:"+mesa));
	String URI = ((HttpServletRequest)request).getRequestURI();
	out.println(Tags.p("",Tags.form(response.encodeURL(URI),"get","",
				     Tags.button(strAccion,Tags.strSubmit,strComer,"","Comer"))));
    }
    public final void comer(final HttpServletRequest request, final HttpServletResponse response)
	throws ServletException, IOException {
	ServletOutputStream out = response.getOutputStream();
	HttpSession sesion = request.getSession();
 	Integer ID = (Integer)sesion.getAttribute(strFilosofoID);
	try {
	    mesa.permisoComer(ID.intValue());
	    out.println(Tags.p("","Filósofo "+ID+" comiendo, cuando quiera pensar pulsar el botón"));
	    out.println(Tags.p("","Estado del monitor:"+mesa));
	    
	    String URI = ((HttpServletRequest)request).getRequestURI();
	    out.println(Tags.p("",Tags.form(response.encodeURL(URI),"get","",
					    Tags.button(strAccion,Tags.strSubmit,strPensar,"","Pensar"))));
	} catch (InterruptedException e) {
	    throw new ServletException(e.getMessage(),e);
	}
	
    }
}
