/*
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation;
  * version 2.1 of the License.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  */
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletResponse;
import javax.servlet.ServletRequest;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;

/**
 * CabeceraHTML.java
 *
 *
 * Created: Mon Aug 18 18:40:34 2003
 *
 * @author <a href="mailto:llana@sip.ucm.es">Luis Fernando Llana Díaz</a>
 * @version $Id: EnvoltorioHTML.java,v 1.1 2007-05-09 22:30:20 luis Exp $
 */
public class EnvoltorioHTML implements Filter {
    private static final String cabecera="html/cabecera.html";
    private static final String pie="html/pie.html";
    private static final String strTitulo="titulo";
    FilterConfig conf;
    /**
     * Describe <code>init</code> method here.
     *
     * @param filterConfig a <code>FilterConfig</code> value
     * @exception ServletException if an error occurs
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        conf = filterConfig;
    }

    /**
     * Describe <code>destroy</code> method here.
     *
     */
    public void destroy() {
        conf = null;
    }

    /**
     * Describe <code>doFilter</code> method here.
     *
     * @param servletRequest a <code>ServletRequest</code> value
     * @param servletResponse a <code>ServletResponse</code> value
     * @param filterChain a <code>FilterChain</code> value
     * @exception IOException if an error occurs
     * @exception ServletException if an error occurs
     */
    public void doFilter(ServletRequest request, 
                         ServletResponse response, 
                         FilterChain filterChain) 
        throws IOException, ServletException {
        String fichero = conf.getServletContext().getRealPath(cabecera);
	String cabecera = IncluyeFichero.incluye(fichero);
	String titulo =  conf.getInitParameter(strTitulo);
        ServletOutputStream out = response.getOutputStream();
	cabecera = cabecera.replaceAll(" <title>"," <title>"+titulo);
	out.println(cabecera);
        filterChain.doFilter(request,response);
        fichero = conf.getServletContext().getRealPath(pie);
	out.println(IncluyeFichero.incluye(fichero));

    }    
} // CabeceraHTML
