/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;

public class JasperLoader
extends URLClassLoader {
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private String className;
    private ClassLoader parent;
    private SecurityManager securityManager;

    public JasperLoader(URL[] urls, ClassLoader parent, PermissionCollection permissionCollection, CodeSource codeSource) {
        super(urls, parent);
        this.permissionCollection = permissionCollection;
        this.codeSource = codeSource;
        this.parent = parent;
        this.securityManager = System.getSecurityManager();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        int dot;
        Class<?> clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.securityManager != null && (dot = name.lastIndexOf(46)) >= 0) {
            try {
                if (!"org.apache.jasper.runtime".equalsIgnoreCase(name.substring(0, dot))) {
                    this.securityManager.checkPackageAccess(name.substring(0, dot));
                }
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                se.printStackTrace();
                throw new ClassNotFoundException(error);
            }
        }
        if (!name.startsWith("org.apache.jsp")) {
            clazz = this.parent.loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return this.findClass(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL url;
        InputStream is = this.parent.getResourceAsStream(name);
        if (is == null && (url = this.findResource(name)) != null) {
            try {
                is = url.openStream();
            }
            catch (IOException iOException) {
                is = null;
            }
        }
        return is;
    }

    public final PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionCollection;
    }
}

