/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;

public class TldLocationsCache {
    private Log log;
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static HashSet noTldJars = new HashSet();
    private Hashtable mappings;
    private boolean initialized;
    private ServletContext ctxt;
    private boolean redeployMode;
    static /* synthetic */ Class class$0;

    static {
        noTldJars.add("ant.jar");
        noTldJars.add("catalina.jar");
        noTldJars.add("catalina-ant.jar");
        noTldJars.add("catalina-cluster.jar");
        noTldJars.add("catalina-optional.jar");
        noTldJars.add("catalina-i18n-fr.jar");
        noTldJars.add("catalina-i18n-ja.jar");
        noTldJars.add("catalina-i18n-es.jar");
        noTldJars.add("commons-dbcp.jar");
        noTldJars.add("commons-modeler.jar");
        noTldJars.add("commons-logging-api.jar");
        noTldJars.add("commons-beanutils.jar");
        noTldJars.add("commons-fileupload-1.0.jar");
        noTldJars.add("commons-pool.jar");
        noTldJars.add("commons-digester.jar");
        noTldJars.add("commons-logging.jar");
        noTldJars.add("commons-collections.jar");
        noTldJars.add("commons-el.jar");
        noTldJars.add("jakarta-regexp-1.2.jar");
        noTldJars.add("jasper-compiler.jar");
        noTldJars.add("jasper-runtime.jar");
        noTldJars.add("jmx.jar");
        noTldJars.add("jmx-tools.jar");
        noTldJars.add("jsp-api.jar");
        noTldJars.add("jkshm.jar");
        noTldJars.add("jkconfig.jar");
        noTldJars.add("naming-common.jar");
        noTldJars.add("naming-resources.jar");
        noTldJars.add("naming-factory.jar");
        noTldJars.add("naming-java.jar");
        noTldJars.add("servlet-api.jar");
        noTldJars.add("servlets-default.jar");
        noTldJars.add("servlets-invoker.jar");
        noTldJars.add("servlets-common.jar");
        noTldJars.add("servlets-webdav.jar");
        noTldJars.add("tomcat-util.jar");
        noTldJars.add("tomcat-http11.jar");
        noTldJars.add("tomcat-jni.jar");
        noTldJars.add("tomcat-jk.jar");
        noTldJars.add("tomcat-jk2.jar");
        noTldJars.add("tomcat-coyote.jar");
        noTldJars.add("xercesImpl.jar");
        noTldJars.add("xmlParserAPIs.jar");
        noTldJars.add("xml-apis.jar");
        noTldJars.add("sunjce_provider.jar");
        noTldJars.add("ldapsec.jar");
        noTldJars.add("localedata.jar");
        noTldJars.add("dnsns.jar");
    }

    public TldLocationsCache(ServletContext ctxt) {
        this(ctxt, true);
    }

    public TldLocationsCache(ServletContext ctxt, boolean redeployMode) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jasper.compiler.TldLocationsCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.ctxt = ctxt;
        this.redeployMode = redeployMode;
        this.mappings = new Hashtable();
        this.initialized = false;
    }

    public static void setNoTldJars(String jarNames) {
        if (jarNames != null) {
            noTldJars.clear();
            StringTokenizer tokenizer = new StringTokenizer(jarNames, ",");
            while (tokenizer.hasMoreElements()) {
                noTldJars.add(tokenizer.nextToken());
            }
        }
    }

    public String[] getLocation(String uri) throws JasperException {
        if (!this.initialized) {
            this.init();
        }
        return (String[])this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void init() throws JasperException {
        if (this.initialized) {
            return;
        }
        try {
            this.processWebDotXml();
            this.scanJars();
            this.processTldsInFileSystem("/WEB-INF/");
            this.initialized = true;
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.internal.tldinit", ex.getMessage()));
        }
    }

    /*
     * Exception decompiling
     */
    private void processWebDotXml() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 433->437)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void scanJar(JarURLConnection conn, boolean ignore) throws JasperException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [1 : 172->175)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTldsInFileSystem(String startPath) throws Exception {
        Set dirList = this.ctxt.getResourcePaths(startPath);
        if (dirList == null) return;
        Iterator it = dirList.iterator();
        while (true) {
            String uri;
            String path;
            block9: {
                Object var7_7;
                if (!it.hasNext()) {
                    return;
                }
                path = (String)it.next();
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                InputStream stream = this.ctxt.getResourceAsStream(path);
                uri = null;
                try {
                    uri = this.getUriFromTld(path, stream);
                }
                catch (Throwable throwable) {
                    var7_7 = null;
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                {
                    var7_7 = null;
                    if (stream == null) break block9;
                }
                try {}
                catch (Throwable throwable) {}
                stream.close();
            }
            if (uri == null || this.mappings.get(uri) != null) continue;
            String[] stringArray = new String[2];
            stringArray[0] = path;
            this.mappings.put(uri, stringArray);
        }
    }

    private String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }

    private void scanJars() throws Exception {
        ClassLoader webappLoader;
        ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader();
        while (loader != null) {
            if (loader instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                int i = 0;
                while (i < urls.length) {
                    URLConnection conn = urls[i].openConnection();
                    if (conn instanceof JarURLConnection) {
                        if (this.needScanJar(loader, webappLoader, ((JarURLConnection)conn).getJarFile().getName())) {
                            this.scanJar((JarURLConnection)conn, true);
                        }
                    } else {
                        String urlStr = urls[i].toString();
                        if (urlStr.startsWith(FILE_PROTOCOL) && urlStr.endsWith(JAR_FILE_SUFFIX) && this.needScanJar(loader, webappLoader, urlStr)) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            this.scanJar((JarURLConnection)jarURL.openConnection(), true);
                        }
                    }
                    ++i;
                }
            }
            loader = loader.getParent();
        }
    }

    private boolean needScanJar(ClassLoader loader, ClassLoader webappLoader, String jarPath) {
        if (loader == webappLoader) {
            return true;
        }
        String jarName = jarPath;
        int slash = jarPath.lastIndexOf(47);
        if (slash >= 0) {
            jarName = jarPath.substring(slash + 1);
        }
        return !noTldJars.contains(jarName);
    }
}

